package dev.isxander.debugify.client.gui;

import dev.isxander.debugify.client.DebugifyClient;
import dev.isxander.debugify.config.DebugifyConfig;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import dev.isxander.debugify.mixinplugin.DebugifyErrorHandler;
import dev.isxander.yacl3.api.*;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class ConfigGuiHelper {
    public static class_437 createConfigGui(DebugifyConfig config, class_437 parent) {
        var yacl = YetAnotherConfigLib.createBuilder()
                .title(class_2561.method_43471("debugify.name"))
                .save(config::save);

        var gameplayWarning = LabelOption.create(class_2561.method_43471("debugify.gameplay.warning").method_27692(class_124.field_1061));
        var gameplayInMultiplayer = Option.<Boolean>createBuilder()
                .name(class_2561.method_43471("debugify.gameplay.enable_in_multiplayer"))
                .binding(
                        false,
                        () -> config.gameplayFixesInMultiplayer,
                        value -> config.gameplayFixesInMultiplayer = value
                )
                .controller(TickBoxControllerBuilder::create)
                .build();

        for (BugFix.Env env : BugFix.Env.values()) {
            var categoryBuilder = ConfigCategory.createBuilder()
                    .name(class_2561.method_43471(env.getDisplayName()))
                    .tooltip(class_2561.method_43471(env.getDescriptionKey()));

            for (FixCategory fixCategory : FixCategory.values()) {
                var groupBuilder = OptionGroup.createBuilder()
                        .name(class_2561.method_43471(fixCategory.getDisplayName()));

                if (fixCategory == FixCategory.GAMEPLAY) {
                    groupBuilder
                            .option(gameplayWarning)
                            .option(gameplayInMultiplayer);
                }

                config.getBugFixes().forEach((bug, enabled) -> {
                    if (bug.env() == env && bug.category() == fixCategory) {
                        var conflicts = bug.getActiveConflicts().stream().map(id -> FabricLoader.getInstance().getModContainer(id).orElseThrow().getMetadata().getName()).toList();
                        var satisfiesOS = bug.satisfiesOSRequirement();
                        var errored = DebugifyErrorHandler.hasErrored(bug);
                        var unavailable = !conflicts.isEmpty() || !satisfiesOS || errored;

                        var optionBuilder = Option.<Boolean>createBuilder()
                                .name(class_2561.method_43470(bug.bugId()))
                                .binding(
                                        bug.enabledByDefault(),
                                        () -> config.getBugFixes().get(bug),
                                        value -> config.getBugFixes().replace(bug, value)
                                )
                                .customController(opt -> new BugFixController(opt, errored))
                                .available(!unavailable)
                                .flag(OptionFlag.GAME_RESTART);

                        OptionDescription.Builder descriptionBuilder = OptionDescription.createBuilder();

                        if (errored) {
                            descriptionBuilder.text(class_2561.method_43469("debugify.error.mixin_error", bug.bugId()).method_27695(class_124.field_1061, class_124.field_1067));
                        }

                        for (String conflictMod : conflicts) {
                            descriptionBuilder.text(class_2561.method_43469("debugify.error.conflict", bug.bugId(), conflictMod).method_27692(class_124.field_1061));
                        }

                        if (!satisfiesOS)
                            descriptionBuilder.text(class_2561.method_43469("debugify.error.os", bug.bugId(), class_2561.method_43471(bug.requiredOs().getDisplayName())).method_27692(class_124.field_1061));

                        if (bug.description() != null)
                            descriptionBuilder.text(class_2561.method_43470(bug.description()));

                        String fixExplanationTooltipKey = "debugify.fix_explanation." + bug.bugId().toLowerCase();
                        if (class_2477.method_10517().method_4678(fixExplanationTooltipKey))
                            descriptionBuilder.text(class_2561.method_43471(fixExplanationTooltipKey).method_27692(class_124.field_1080));

                        String fixEffectTooltipKey = "debugify.fix_effect." + bug.bugId().toLowerCase();
                        if (class_2477.method_10517().method_4678(fixEffectTooltipKey))
                            descriptionBuilder.text(class_2561.method_43471(fixEffectTooltipKey).method_27692(class_124.field_1065));

                        optionBuilder.description(descriptionBuilder.build());

                        groupBuilder.option(optionBuilder.build());
                    }
                });

                categoryBuilder.group(groupBuilder.build());
            }

            yacl.category(categoryBuilder.build());
        }

        yacl.category(ConfigCategory.createBuilder()
                .name(class_2561.method_43471("debugify.misc"))
                .option(Option.<Boolean>createBuilder()
                        .name(class_2561.method_43471("debugify.misc.default_disabled"))
                        .description(OptionDescription.of(class_2561.method_43471("debugify.misc.default_disabled.description")))
                        .binding(
                                false,
                                () -> config.defaultDisabled,
                                value -> config.defaultDisabled = value
                        )
                        .controller(BooleanControllerBuilder::create)
                        .build())
                .build());

        return yacl.build().generateScreen(parent);
    }
}
