package dev.isxander.debugify.client.helpers.mc237493;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_7291;

public enum DebugifyTelemetry implements class_7291 {
    OFF(0, "options.telemetry.state.none", "debugify.mc_237493.tooltip.off"),
    MINIMAL(1, "options.telemetry.state.minimal", "debugify.mc_237493.tooltip.minimal"),
    ALL(2, "options.telemetry.state.all", "debugify.mc_237493.tooltip.all");

    private static final DebugifyTelemetry[] VALUES = Arrays.stream(values())
            .sorted(Comparator.comparingInt(DebugifyTelemetry::method_7362))
            .toArray(DebugifyTelemetry[]::new);

    private final int id;
    private final String translationKey;
    private final String tooltipTranslationKey;

    DebugifyTelemetry(int id, String translationKey, String tooltipTranslationKey) {
        this.id = id;
        this.translationKey = translationKey;
        this.tooltipTranslationKey = tooltipTranslationKey;
    }

    @Override
    public int method_7362() {
        return this.id;
    }

    @Override
    public String method_7359() {
        return this.translationKey;
    }

    public String getTooltipKey() {
        return this.tooltipTranslationKey;
    }

    public class_2561 getTooltipText() {
        return class_2561.method_43469(getTooltipKey(), method_42627());
    }

    public static DebugifyTelemetry byId(int id) {
        return VALUES[class_3532.method_15387(id, VALUES.length)];
    }
}
