package dev.isxander.debugify.client.mixins.basic.mc115092;

import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_10069;
import net.minecraft.class_1477;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_951;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@BugFix(id = "MC-115092", category = FixCategory.BASIC, env = BugFix.Env.CLIENT, description = "Squid/glow squid named \"Dinnerbone\" or \"Grumm\" is not upside-down")
@Mixin(class_951.class)
public class SquidRendererMixin<T extends class_1477> {
    @Unique
    T squidEntity;

    @Inject(method = "extractRenderState(Lnet/minecraft/world/entity/animal/Squid;Lnet/minecraft/client/renderer/entity/state/SquidRenderState;F)V", at = @At("TAIL"))
    private void getSquidEntity(T squid, class_10069 squidRenderState, float f, CallbackInfo ci) {
        squidEntity = squid;
    }

    @Inject(method = "setupRotations(Lnet/minecraft/client/renderer/entity/state/SquidRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;FF)V", at = @At("TAIL"))
    private void applyRotation(class_10069 squidRenderState, class_4587 poseStack, float f, float g, CallbackInfo ci) {
        String name = squidEntity.method_5477().getString();
        if ("Dinnerbone".equals(name) || "Grumm".equals(name)) {
            poseStack.method_46416(0.0F, squidEntity.method_17682() + 0.1F, 0.0F);
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0F));
        }
    }
}
