package dev.isxander.debugify.client.mixins.basic.mc197260;

import com.mojang.datafixers.util.Pair;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import org.spongepowered.asm.mixin.Mixin;

import java.util.Comparator;
import java.util.stream.IntStream;
import net.minecraft.class_1531;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_548;
import net.minecraft.class_5617;
import net.minecraft.class_638;
import net.minecraft.class_765;
import net.minecraft.class_877;
import net.minecraft.class_9998;

@BugFix(id = "MC-197260", category = FixCategory.BASIC, env = BugFix.Env.CLIENT, description = "Armor Stand renders itself and armor dark if its head is in a solid block")
@Mixin(class_877.class)
public abstract class ArmorStandRendererMixin extends LivingEntityRendererMixin<class_1531, class_9998, class_548> {
    protected ArmorStandRendererMixin(class_5617.class_5618 context) {
        super(context);
    }

    /**
     * Overrides the light level passed to the renderer, with the maximum of:
     * <ul>
     *     <li>The block below the armor stand</li>
     *     <li>Bottom of the armor stand</li>
     *     <li>Top of the armor stand</li>
     *     <li>The block above the armor stand</li>
     * </ul>
     */
    @Override
    public void debugify$modifyLightCoords(class_9998 livingEntity) {
        class_2338 mainPos = class_2338.method_49637(livingEntity.field_53325, livingEntity.field_53326, livingEntity.field_53327);
        class_638 level = class_310.method_1551().field_1687;

        livingEntity.field_61820 = IntStream.of(-1, 0, 2, 3)
                .mapToObj(operand -> {
                    class_2338 pos = mainPos.method_10069(0, operand, 0);
                    return Pair.of(level.method_8314(class_1944.field_9282, pos), pos);
                })
                .max(Comparator.comparingInt(Pair::getFirst))
                .map(p -> class_765.method_23687(p.getFirst(), level.method_8314(class_1944.field_9284, p.getSecond())))
                .orElse(livingEntity.field_61820);
    }
}
