package dev.isxander.debugify.client.mixins.basic.mc206540;

import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1297;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@BugFix(id = "MC-206540", category = FixCategory.BASIC, env = BugFix.Env.CLIENT, modConflicts = "ridingmousefix", description = "Increased input delay when riding an entity")
@Mixin(class_1297.class)
public abstract class EntityMixin {
    @Shadow
    public abstract float getYRot();

    /**
     * Code taken from {@link net.minecraft.class_10255}
     */
    @Inject(method = "onPassengerTurned", at = @At("HEAD"))
    private void fixCameraMovement(class_1297 entity, CallbackInfo ci) {
        if (entity.method_31747()) {
            entity.method_5636(this.getYRot());
            float f = class_3532.method_15393(entity.method_36454() - this.getYRot());
            float g = class_3532.method_15363(f, -180.0F, 180.0F);
            entity.field_5982 += g - f;
            entity.method_36456(entity.method_36454() + g - f);
            entity.method_5847(entity.method_36454());
        }
    }
}
