package dev.isxander.debugify.client.mixins.basic.mc22882;

import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import dev.isxander.debugify.fixes.OS;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@BugFix(id = "MC-22882", category = FixCategory.BASIC, env = BugFix.Env.CLIENT, os = OS.MAC, modConflicts = "ctrl-q", description = "Ctrl + Q won't work on Mac")
@Mixin(class_310.class)
public class MinecraftMixin {
    @ModifyArg(method = "handleKeybinds", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/player/LocalPlayer;drop(Z)Z"))
    private boolean shouldDropEntireStack(boolean ctrlPressed) {
        var window = class_310.method_1551().method_22683();
        return class_3675.method_15987(window, class_3675.field_31950)
                || class_3675.method_15987(window, class_3675.field_31954);
    }
}
