package dev.isxander.debugify.mixins.basic.mc129909;

import com.mojang.authlib.GameProfile;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@BugFix(id = "MC-129909", category = FixCategory.BASIC, env = BugFix.Env.SERVER, description = "Players in spectator mode continue to consume foods and liquids shortly after switching game modes")
@Mixin(class_3222.class)
public abstract class ServerPlayerMixin extends class_1657 {
    public ServerPlayerMixin(class_1937 world, GameProfile gameProfile) {
        super(world, gameProfile);
    }

    /**
     * Also fixes
     * <a href="https://bugs.mojang.com/browse/MC-81773">MC-81773</a>, <a href="https://bugs.mojang.com/browse/MC-206705">MC-206705</a>
     */
    @Inject(method = "setGameMode", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/level/ServerPlayer;stopRiding()V"))
    private void onChangeToSpectator(class_1934 gameMode, CallbackInfoReturnable<Boolean> cir) {
        method_6075();
    }
}
