package dev.isxander.debugify.mixins.basic.mc147659;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1451;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4274;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@BugFix(id = "MC-147659", category = FixCategory.BASIC, env = BugFix.Env.SERVER, description = "Some witch huts spawn the incorrect cat")
@Mixin(class_4274.class)
public class CatSpawnerMixin {
    @WrapWithCondition(method = "spawnCat", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/animal/Cat;snapTo(Lnet/minecraft/core/BlockPos;FF)V"))
    private boolean removeOldCatSnap(class_1451 instance, class_2338 blockPos, float yaw, float pitch) {
        return false;
    }

    @Inject(method = "spawnCat", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/animal/Cat;finalizeSpawn(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/DifficultyInstance;Lnet/minecraft/world/entity/EntitySpawnReason;Lnet/minecraft/world/entity/SpawnGroupData;)Lnet/minecraft/world/entity/SpawnGroupData;"))
    private void addNewCatSnap(class_2338 pos, class_3218 level, boolean persistent, CallbackInfo ci, @Local class_1451 cat) {
        cat.method_5725(pos, 0, 0);
    }
}
