package dev.isxander.debugify.mixins.basic.mc179072;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1309;
import net.minecraft.class_1389;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@BugFix(id = "MC-179072", category = FixCategory.BASIC, env = BugFix.Env.SERVER, description = "Creepers do not defuse when switching from Survival to Creative/Spectator")
@Mixin(class_1389.class)
public class SwellGoalMixin {
    @Shadow private @Nullable class_1309 target;

    @ModifyExpressionValue(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/ai/sensing/Sensing;hasLineOfSight(Lnet/minecraft/world/entity/Entity;)Z"))
    private boolean shouldIgniteCreeper(boolean canSeeTarget) {
        return canSeeTarget && target.method_33190();
    }
}
