package dev.isxander.debugify.mixins.basic.mc206922;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1297;
import net.minecraft.class_1538;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@BugFix(id = "MC-206922", category = FixCategory.BASIC, env = BugFix.Env.SERVER, description = "Items dropped by entities that are killed by lightning instantly disappear")
@Mixin(class_1297.class)
public class EntityMixin {
    @Shadow public int tickCount;

    @WrapMethod(method = "thunderHit")
    protected void bypassStruckByLightning(class_3218 world, class_1538 lightning, Operation<Void> operation) {
        operation.call(world, lightning);
    }
}
