package dev.isxander.debugify.mixins.basic.mc221257;

import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1299;
import net.minecraft.class_1676;
import net.minecraft.class_1678;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@BugFix(id = "MC-221257", category = FixCategory.BASIC, env = BugFix.Env.SERVER, description = "Shulker bullets don't produce bubble particles when moving through water")
@Mixin(class_1678.class)
public abstract class ShulkerBulletMixin extends class_1676 {
    public ShulkerBulletMixin(class_1299<? extends class_1676> entityType, class_1937 level) {
        super(entityType, level);
    }

    /**
     * Code taken from {@link net.minecraft.class_1665}
     */
    @Inject(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/projectile/ShulkerBullet;setPos(Lnet/minecraft/world/phys/Vec3;)V"))
    private void addMissingBubbleParticles(CallbackInfo ci) {
        if (this.method_5799()) {
            class_243 vec3 = this.method_73189();
            class_243 vec32 = this.method_18798();

            for (int i = 0; i < 4; ++i) {
                this.method_73183().method_8406(class_2398.field_11247, vec3.field_1352 - vec32.field_1352 * (double) 0.25F, vec3.field_1351 - vec32.field_1351 * (double) 0.25F, vec3.field_1350 - vec32.field_1350 * (double) 0.25F, vec32.field_1352, vec32.field_1351, vec32.field_1350);
            }
        }
    }
}
