package dev.isxander.debugify.mixins.basic.mc226961;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1937;
import net.minecraft.class_3486;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@BugFix(id = "MC-226961", category = FixCategory.BASIC, env = BugFix.Env.SERVER, description = "Experience Orbs treat flowing lava as a full block")
@Mixin(class_1303.class)
public abstract class ExperienceOrbMixin extends class_1297 {
    public ExperienceOrbMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Definition(id = "getFluidState", method = "Lnet/minecraft/world/level/Level;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;")
    @Definition(id = "is", method = "Lnet/minecraft/world/level/material/FluidState;is(Lnet/minecraft/tags/TagKey;)Z")
    @Definition(id = "LAVA", field = "Lnet/minecraft/tags/FluidTags;LAVA:Lnet/minecraft/tags/TagKey;")
    @Expression("?.getFluidState(?).is(LAVA)")
    @ModifyExpressionValue(method = "tick", at = @At("MIXINEXTRAS:EXPRESSION"))
    private boolean checkEyeLevel(boolean original) {
        return this.method_5777(class_3486.field_15518);
    }
}
