package dev.isxander.debugify.mixins.basic.mc263999;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1308;
import net.minecraft.class_1339;
import net.minecraft.class_1343;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * removeBlock is called before querying the block state of the door,
 * which breaks the level event that causes particles
 */
@BugFix(id = "MC-263999", category = FixCategory.BASIC, env = BugFix.Env.SERVER, description = "Zombies breaking doors do not show break particles")
@Mixin(class_1339.class)
public class BreakDoorGoalMixin extends class_1343 {
    public BreakDoorGoalMixin(class_1308 mob) {
        super(mob);
    }

    // Store the block state before removal
    @Inject(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;removeBlock(Lnet/minecraft/core/BlockPos;Z)Z"))
    private void storeBlockStatePreRemoval(CallbackInfo ci, @Share("blockState") LocalRef<class_2680> blockStateRef) {
        blockStateRef.set(this.field_6413.method_73183().method_8320(this.field_6414));
    }

    // Use the stored block state for the level event
    @Definition(id = "levelEvent", method = "Lnet/minecraft/world/level/Level;levelEvent(ILnet/minecraft/core/BlockPos;I)V")
    @Definition(id = "getId", method = "Lnet/minecraft/world/level/block/Block;getId(Lnet/minecraft/world/level/block/state/BlockState;)I")
    @Definition(id = "getBlockState", method = "Lnet/minecraft/world/level/Level;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;")
    @Definition(id = "doorPos", field = "Lnet/minecraft/world/entity/ai/goal/BreakDoorGoal;doorPos:Lnet/minecraft/core/BlockPos;")
    @Expression("?.levelEvent(2001, ?, getId(@(?.getBlockState(?.doorPos))))")
    @WrapOperation(method = "tick", at = @At("MIXINEXTRAS:EXPRESSION"))
    private class_2680 injectCorrectBlockState(class_1937 instance, class_2338 pos, Operation<class_2680> original, @Share("blockState") LocalRef<class_2680> blockStateRef) {
        return blockStateRef.get();
    }
}
