package dev.isxander.debugify.mixins.basic.mc272431;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1510;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@BugFix(id = "MC-272431", category = FixCategory.BASIC, env = BugFix.Env.SERVER, description = "Ender Dragon incorrect vertical velocity causes erratic behavior")
@Mixin(class_1510.class)
public class EnderDragonMixin {
    @ModifyExpressionValue(method = "aiStep", at = @At(value = "CONSTANT", args = "doubleValue=0.01"))
    private double fixTargetPath(double value) {
        return 0.1;
    }

    @Definition(id = "setDeltaMovement", method = "Lnet/minecraft/world/entity/boss/enderdragon/EnderDragon;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V")
    @Definition(id = "add", method = "Lnet/minecraft/world/phys/Vec3;add(DDD)Lnet/minecraft/world/phys/Vec3;")
    @Expression("?.setDeltaMovement(?.add(0.0, ? * @(0.01), 0.0))")
    @ModifyExpressionValue(method = "aiStep", at = @At("MIXINEXTRAS:EXPRESSION"))
    private double fixVerticalVelocity(double value) {
        return 0.1;
    }
}
