package dev.isxander.debugify.mixins.basic.mc93018;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1429;
import net.minecraft.class_1493;
import net.minecraft.class_1657;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@BugFix(id = "MC-93018", category = FixCategory.BASIC, env = BugFix.Env.SERVER, description = "Wild wolves show breeding hearts but do not breed")
@Mixin(class_1429.class)
public class AnimalMixin {
    /**
     * Only make wolves love player if they are tamed when fed
     */
    @WrapWithCondition(method = "mobInteract", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/animal/Animal;setInLove(Lnet/minecraft/world/entity/player/Player;)V"))
    private boolean loveCondition(class_1429 animal, class_1657 player) {
        if (animal instanceof class_1493 wolf) {
            return wolf.method_6181();
        }

        return true;
    }
}
