package dev.isxander.debugify.client.gui;

import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.BooleanController;
import net.minecraft.class_124;
import net.minecraft.class_2561;

public class BugFixController extends BooleanController {
    public BugFixController(Option<Boolean> option, boolean errored) {
        super(option, state -> {
            if (errored)
                return class_2561.method_43471("debugify.error.mixin_error.text").method_27692(class_124.field_1061);
            if (!option.available())
                return class_2561.method_43471("debugify.fix.unavailable");
            return state
                    ? class_2561.method_43471("debugify.fix.enabled").method_27692(class_124.field_1060)
                    : class_2561.method_43471("debugify.fix.disabled").method_27692(class_124.field_1061);
        }, false);
    }

    @Override
    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new BugFixControllerElement(this, screen, widgetDimension);
    }

    public static class BugFixControllerElement extends BooleanControllerElement {
        private String tooltipString;

        public BugFixControllerElement(BugFixController control, YACLScreen screen, Dimension<Integer> dim) {
            super(control, screen, dim);
            control.option().addListener((opt, pending) -> recalculateTooltipString());
            recalculateTooltipString();
        }

        @Override
        public boolean matchesSearch(String query) {
            return super.matchesSearch(query) || tooltipString.contains(query.toLowerCase());
        }

        private void recalculateTooltipString() {
            this.tooltipString = control.option().description().text().getString().toLowerCase();
        }
    }
}
