package dev.isxander.debugify.client.mixins.basic.mc116379;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1306;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_906;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@BugFix(id = "MC-116379", category = FixCategory.BASIC, env = BugFix.Env.CLIENT, description = "Punching with a cast fishing rod in the off-hand detaches fishing line from rod")
@Mixin(class_906.class)
public class FishingHookRendererMixin {
    @ModifyExpressionValue(method = "extractRenderState(Lnet/minecraft/world/entity/projectile/FishingHook;Lnet/minecraft/client/renderer/entity/state/FishingHookRenderState;F)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;getAttackAnim(F)F"))
    private float modifyHandSwingProgress(float handSwingProgress, class_1536 bobber) {
        class_1657 player = bobber.method_6947();
        int j = player.method_6068() == class_1306.field_6183 ? 1 : -1;
        int j2 = j;
        class_1799 itemStack = player.method_6047();
        if (!itemStack.method_31574(class_1802.field_8378)) {
            j = -j;
        }

        return j == j2 ? handSwingProgress : 0;
    }
}
