package dev.isxander.debugify.client.mixins.basic.mc122477;

import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import dev.isxander.debugify.client.helpers.mc122477.KeyboardPollCounter;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.isxander.debugify.fixes.OS;
import net.minecraft.class_10219;
import net.minecraft.class_1041;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@BugFix(id = "MC-122477", category = FixCategory.BASIC, env = BugFix.Env.CLIENT, os = OS.LINUX, description = "Linux/GNU: Opening chat sometimes writes 't'")
@Mixin(value = RenderSystem.class, priority = 1100) // higher priority to improve compatibility with VulkanMod
public class RenderSystemMixin {
    @Inject(method = "flipFrame", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/systems/RenderSystem;pollEvents()V"))
    private static void onPollEvents(class_1041 window, class_10219 tracyFrameCapture, CallbackInfo ci) {
        KeyboardPollCounter.poll();
    }
}
