package dev.isxander.debugify.client.mixins.basic.mc165381;

import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@BugFix(id = "MC-165381", category = FixCategory.BASIC, env = BugFix.Env.CLIENT, description = "Block breaking can be delayed by dropping/throwing the tool while breaking a block")
@Mixin(class_746.class)
public class LocalPlayerMixin {
    @Shadow
    @Final
    protected class_310 minecraft;

    @Inject(method = "drop", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Inventory;removeFromSelected(Z)Lnet/minecraft/world/item/ItemStack;", shift = At.Shift.AFTER))
    private void onDropItem(boolean entireStack, CallbackInfoReturnable<Boolean> cir) {
        minecraft.field_1761.method_2925();
    }
}
