package dev.isxander.debugify.client.mixins.basic.mc188359;

import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_10124;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@BugFix(id = "MC-188359", category = FixCategory.BASIC, env = BugFix.Env.CLIENT, description = "Burp sound does not play after drinking or after eating cake")
@Mixin(class_10124.class)
public class ConsumableMixin {
    @Shadow
    @Final
    private class_6880<class_3414> sound;

    @Inject(method = "onConsume", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;consume(ILnet/minecraft/world/entity/LivingEntity;)V"))
    private void addBurpSound(class_1937 level, class_1309 livingEntity, class_1799 itemStack, CallbackInfoReturnable<class_1799> cir) {
        if (this.sound.method_55838(class_3417.field_20613) && livingEntity.method_31747()) {
            level.method_8486(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), class_3417.field_19149, class_3419.field_15248, 0.5F, class_3532.method_32750(livingEntity.method_59922(), 0.9F, 1.0F), false);
        }
    }
}
