package dev.isxander.debugify.client.mixins.basic.mc217716;

import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_310;
import net.minecraft.class_757;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@BugFix(id = "MC-217716", category = FixCategory.BASIC, env = BugFix.Env.CLIENT, description = "The green nausea overlay isn't removed when switching into spectator mode")
@Mixin(class_757.class)
public class GameRendererMixin {
    @Shadow @Final
    private class_310 minecraft;

    @ModifyExpressionValue(method = "renderLevel", at = @At(value = "INVOKE", target = "Ljava/lang/Double;floatValue()F"))
    private float shouldShowNauseaOverlay(float original) {
        return minecraft.field_1724.method_7325() ? 0.0f : original;
    }
}
