package dev.isxander.debugify.client.mixins.basic.mc237493;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import dev.isxander.debugify.client.helpers.mc237493.DebugifyTelemetry;
import dev.isxander.debugify.client.helpers.mc237493.DebugifyTelemetryAccessor;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_7941;
import net.minecraft.class_7966;

@BugFix(id = "MC-237493", category = FixCategory.BASIC, env = BugFix.Env.CLIENT, modConflicts = "no-telemetry", description = "Telemetry cannot be disabled")
@Mixin(class_7941.class)
public class TelemetryEventWidgetMixin {
    @Shadow @Final private class_327 font;

    @ModifyExpressionValue(method = "buildContent", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/telemetry/TelemetryEventType;values()Ljava/util/List;"))
    private List<class_7966> modifyInUseTelemetry(List<class_7966> inUse) {
        if (((DebugifyTelemetryAccessor) class_310.method_1551().field_1690).getTelemetryOption().method_41753() == DebugifyTelemetry.OFF)
            return List.of();
        return inUse;
    }

    @Inject(method = "buildContent", at = @At(value = "INVOKE", target = "Ljava/util/List;sort(Ljava/util/Comparator;)V"))
    private void addDebugifyContent(boolean bl, CallbackInfoReturnable<class_7941.class_7942> cir, @Local class_7941.class_7943 contentBuilder) {
        if (((DebugifyTelemetryAccessor) class_310.method_1551().field_1690).getTelemetryOption().method_41753() == DebugifyTelemetry.OFF) {
            contentBuilder.method_47645(this.font, class_2561.method_43471("debugify.mc_237493.header"));
            contentBuilder.method_47643(this.font, class_2561.method_43469("debugify.mc_237493.line", class_2561.method_43471("options.telemetry.state.none")).method_27692(class_124.field_1080));
        }
    }
}
