package dev.isxander.debugify.client.mixins.basic.mc242809;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_422;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@BugFix(id = "MC-242809", category = FixCategory.BASIC, env = BugFix.Env.CLIENT, description = "IP field in the multiplayer menu will not detect the IP if a space is put at the beginning/end of it")
@Mixin(class_422.class)
public class ManageServerScreenMixin {
    @Definition(id = "serverData", field = "Lnet/minecraft/client/gui/screens/ManageServerScreen;serverData:Lnet/minecraft/client/multiplayer/ServerData;")
    @Definition(id = "ip", field = "Lnet/minecraft/client/multiplayer/ServerData;ip:Ljava/lang/String;")
    @Definition(id = "ipEdit", field = "Lnet/minecraft/client/gui/screens/ManageServerScreen;ipEdit:Lnet/minecraft/client/gui/components/EditBox;")
    @Definition(id = "getValue", method = "Lnet/minecraft/client/gui/components/EditBox;getValue()Ljava/lang/String;")
    @Expression("this.serverData.ip = @(this.ipEdit.getValue())")
    @ModifyExpressionValue(method = "onAdd", at = @At("MIXINEXTRAS:EXPRESSION"))
    private String trimIp(String ip) {
        return ip.trim();
    }
}
