package dev.isxander.debugify.client.mixins.basic.mc268420;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@BugFix(id = "MC-268420", category = FixCategory.BASIC, env = BugFix.Env.CLIENT, description = "Cooldown indicator flashes when switching items with high attack speed attribute")
@Mixin(class_329.class)
public class GuiMixin {
    @Shadow
    @Final
    private class_310 minecraft;

    // the FULL sprite never shows anyway so no need to wrap it
    @WrapWithCondition(method = "renderCrosshair", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal = 2))
    private boolean fixAttackIndicatorFlashing(class_332 instance, RenderPipeline renderPipeline, class_2960 resourceLocation, int i, int j, int k, int l) {
        return this.minecraft.field_1724.method_7261(0.0F) * 17F > 0;
    }
}
