package dev.isxander.debugify.client.mixins.basic.mc35361;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1156;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@BugFix(id = "MC-35361", category = FixCategory.BASIC, env = BugFix.Env.CLIENT, description = "Inventory opening is detected while in Nether Portal")
@Mixin(class_310.class)
public class MinecraftMixin {
    @Shadow
    @Nullable
    public class_746 player;

    @WrapWithCondition(method = "handleKeybinds", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/tutorial/Tutorial;onOpenInventory()V"))
    private boolean addNetherPortalCheck(class_1156 instance) {
        return this.player.field_51994 == null || !this.player.field_51994.method_60709();
    }
}
