package dev.isxander.debugify.client.mixins.basic.mc577;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_11909;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@BugFix(id = "MC-577", category = FixCategory.BASIC, env = BugFix.Env.CLIENT, description = "Mouse buttons block all inventory controls that are not default")
@Mixin(class_465.class)
public abstract class AbstractContainerScreenMixin extends class_437 {
    @Shadow
    protected abstract void slotClicked(class_1735 slot, int slotId, int button, class_1713 actionType);

    protected AbstractContainerScreenMixin(class_2561 title) {
        super(title);
    }

    @ModifyExpressionValue(method = "mouseClicked", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/Screen;mouseClicked(Lnet/minecraft/client/input/MouseButtonEvent;Z)Z"))
    private boolean shouldReturn(boolean original, class_11909 mouseButtonEvent) {
        return original || mouseInventoryClose(mouseButtonEvent);
    }

    @Definition(id = "getHoveredSlot", method = "Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;getHoveredSlot(DD)Lnet/minecraft/world/inventory/Slot;")
    @Expression("? = this.getHoveredSlot(?, ?)")
    @Inject(method = "mouseClicked", at = @At(value = "MIXINEXTRAS:EXPRESSION", shift = At.Shift.AFTER), cancellable = true)
    private void dropWithMouse(class_11909 event, boolean bl, CallbackInfoReturnable<Boolean> cir, @Local(ordinal = 0) class_1735 hoveredSlot) {
        if (field_22787.field_1690.field_1869.method_1433(event)) {
            if (hoveredSlot == null) return;
            slotClicked(hoveredSlot, hoveredSlot.field_7874, event.method_74240() ? 1 : 0, class_1713.field_7795);
            cir.setReturnValue(true);
        }
    }

    @Unique
    private boolean mouseInventoryClose(class_11909 button) {
        if (field_22787.field_1690.field_1822.method_1433(button)) {
            method_25419();
            return true;
        }

        return false;
    }
}
