package dev.isxander.debugify.client.mixins.basic.mc59810;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import dev.isxander.debugify.fixes.OS;
import net.minecraft.class_312;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@BugFix(id = "MC-59810", category = FixCategory.BASIC, env = BugFix.Env.CLIENT, enabled = false, modConflicts = "mcmouser", os = OS.MAC, description = "Cannot break blocks while sprinting (Ctrl+Click = right click on macOS)")
@Mixin(class_312.class)
public class MouseHandlerMixin {
    @ModifyExpressionValue(method = "simulateRightClick", at = @At(value = "FIELD", target = "Lnet/minecraft/client/input/InputQuirks;SIMULATE_RIGHT_CLICK_WITH_LONG_LEFT_CLICK:Z", opcode = Opcodes.GETSTATIC))
    private boolean doRightClickEmulation(boolean isMac) {
        return false;
    }
}
