package dev.isxander.debugify.client.mixins.basic.mc80859;

import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

import java.util.Set;
import net.minecraft.class_1735;
import net.minecraft.class_465;

@BugFix(id = "MC-80859", category = FixCategory.BASIC, env = BugFix.Env.CLIENT, description = "Starting to drag item stacks over other compatible stacks makes the latter invisible until appearance change (stack size increases)")
@Mixin(class_465.class)
public class AbstractContainerScreenMixin {
    /**
     * If slots is size 1 then the inner method would run anyway and return so this just ignores the outer
     * statement and lets it continue to the rendering therefore fixing the bug.
     */
    @Redirect(method = "renderSlot", at = @At(value = "INVOKE", target = "Ljava/util/Set;contains(Ljava/lang/Object;)Z"))
    private boolean onQuickCraftCheck(Set<class_1735> cursorDragSlots, Object slot) {
        if (cursorDragSlots.size() == 1) return false;
        //noinspection SuspiciousMethodCalls
        return cursorDragSlots.contains(slot);
    }
}
