package dev.isxander.debugify.mixins.basic.mc100991;

import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1536;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@BugFix(id = "MC-100991", category = FixCategory.BASIC, env = BugFix.Env.SERVER, description = "Killing entities with a fishing rod doesn't count as a kill")
@Mixin(class_1536.class)
public abstract class FishingHookMixin extends ProjectileMixin {
    public FishingHookMixin(class_1299<?> variant, class_1937 world) {
        super(variant, world);
    }

    /**
     * notifies the combat tracker
     */
    @Inject(method = "pullEntity", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"))
    private void onPullEntity(class_1297 entity, CallbackInfo ci) {
        if (entity instanceof class_1309 livingEntity) {
            livingEntity.method_6066().method_5547(
                    method_73183().method_48963().method_48811((class_1536)(Object)this, getOwner()),
                    livingEntity.method_6032()
            );
        }
    }
}
