package dev.isxander.debugify.mixins.basic.mc153010;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1928;
import net.minecraft.class_3218;
import net.minecraft.class_4019;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@BugFix(id = "MC-153010", category = FixCategory.BASIC, env = BugFix.Env.SERVER, description = "doMobLoot gamerule doesn't prevent foxes from dropping their items")
@Mixin(class_4019.class)
public class FoxMixin {
    // gate dropping death loot with gamerule check
    @ModifyExpressionValue(method = "dropAllDeathLoot", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;isEmpty()Z"))
    private boolean preventLootDropIfGameruleIsFalse(boolean isEmpty, class_3218 level) {
        return isEmpty || !level.method_64395().method_8355(class_1928.field_19391);
    }
}
