package dev.isxander.debugify.mixins.basic.mc168573;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_10707;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@BugFix(id = "MC-168573", category = FixCategory.BASIC, env = BugFix.Env.SERVER, description = "After breaking a shield, the player's off-hand can't finish using some items")
@Mixin(class_10707.class)
public class BlocksAttacksMixin {
    /**
     * We need to check if the shield is going to break and only stop using the item after it is broken.
     * We can't use isBroken here, so instead we check if the next damage will break the blockable, then do the damage call after.
     */
    @WrapOperation(method = "hurtBlockingItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;hurtAndBreak(ILnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/EquipmentSlot;)V"))
    private void fixShieldBreakItemUse(class_1799 instance, int amount, class_1309 entity, class_1304 slot, Operation<Void> original, @Local(argsOnly = true) class_1799 stack) {
        boolean isBroken = stack.method_63692();
        original.call(instance, amount, entity, slot);
        if (isBroken) entity.method_6021();
    }
}
