package dev.isxander.debugify.mixins.basic.mc183990;

import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@BugFix(id = "MC-183990", category = FixCategory.BASIC, env = BugFix.Env.SERVER, description = "Group AI of some mobs breaks when their target dies")
@Mixin(class_1308.class)
public abstract class MobMixin {
    @Shadow private @Nullable class_1309 target;

    @Shadow public abstract void setTarget(@Nullable class_1309 target);

    @Inject(method = "baseTick", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/profiling/ProfilerFiller;pop()V"))
    private void clearTargetIfDead(CallbackInfo ci) {
        if (target != null && target.method_29504()) {
            setTarget(null);
        }
    }
}
