package dev.isxander.debugify.mixins.basic.mc219981;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1299;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1588;
import net.minecraft.class_1642;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@BugFix(id = "MC-219981", category = FixCategory.BASIC, env = BugFix.Env.SERVER, description = "If zombies spawned with max health over 20 (leader zombie bonus), they will have 20 health instead of their max health")
@Mixin(class_1642.class)
public class ZombieMixin extends class_1588 {
    protected ZombieMixin(class_1299<? extends class_1588> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Definition(id = "getAttribute", method = "Lnet/minecraft/world/entity/monster/Zombie;getAttribute(Lnet/minecraft/core/Holder;)Lnet/minecraft/world/entity/ai/attributes/AttributeInstance;")
    @Definition(id = "MAX_HEALTH", field = "Lnet/minecraft/world/entity/ai/attributes/Attributes;MAX_HEALTH:Lnet/minecraft/core/Holder;")
    @Definition(id = "addOrReplacePermanentModifier", method = "Lnet/minecraft/world/entity/ai/attributes/AttributeInstance;addOrReplacePermanentModifier(Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;)V")
    @Definition(id = "LEADER_ZOMBIE_BONUS_ID", field = "Lnet/minecraft/world/entity/monster/Zombie;LEADER_ZOMBIE_BONUS_ID:Lnet/minecraft/resources/ResourceLocation;")
    @Definition(id = "AttributeModifier", type = class_1322.class)
    @Expression("this.getAttribute(MAX_HEALTH).addOrReplacePermanentModifier(new AttributeModifier(LEADER_ZOMBIE_BONUS_ID, ?, ?))")
    @WrapOperation(method = "handleAttributes", at = @At("MIXINEXTRAS:EXPRESSION"))
    private void fixLeaderZombieHealth(class_1324 instance, class_1322 modifier, Operation<Void> original) {
        float damageTaken = this.method_6063() - this.method_6032();

        // apply attribute, max health will increase
        original.call(instance, modifier);

        this.method_6033(this.method_6063() - damageTaken);
    }
}
