package dev.isxander.debugify.mixins.basic.mc232869;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1267;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1937;
import net.minecraft.class_4985;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@BugFix(id = "MC-232869", category = FixCategory.BASIC, env = BugFix.Env.SERVER, description = "Adult striders can spawn with saddles in peaceful mode")
@Mixin(class_4985.class)
public abstract class StriderMixin extends class_1429 {
    protected StriderMixin(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    @ModifyExpressionValue(method = "finalizeSpawn", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/RandomSource;nextInt(I)I", ordinal = 0))
    private int preventPeacefulJockey(int random) {
        // non-zero doesn't spawn jockey
        return method_73183().method_8407() == class_1267.field_5801 ? 1 : random;
    }
}
