package dev.isxander.debugify.mixins.basic.mc30391;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1528;
import net.minecraft.class_1545;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@BugFix(id = "MC-30391", category = FixCategory.BASIC, env = BugFix.Env.SERVER, description = "Chickens, blazes and the wither emit particles when landing from a height, despite falling slowly")
@Mixin(class_1309.class)
public class LivingEntityMixin {
    @ModifyExpressionValue(method = "checkFallDamage", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/state/BlockState;isAir()Z"))
    private boolean shouldntSpawnParticles(boolean isAir) {
        class_1309 self = (class_1309) (Object) this;
        return isAir || self instanceof class_1428 || self instanceof class_1545 || self instanceof class_1528;
    }
}
