/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers;

import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class LabelController
implements Controller<Component> {
    private final Option<Component> option;

    public LabelController(Option<Component> option) {
        this.option = option;
    }

    @Override
    public Option<Component> option() {
        return this.option;
    }

    @Override
    public Component formatValue() {
        return this.option().pendingValue();
    }

    @Override
    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new LabelControllerElement(screen, widgetDimension);
    }

    public class LabelControllerElement
    extends AbstractWidget {
        private List<FormattedCharSequence> wrappedText;
        protected MultiLineLabel wrappedTooltip;
        protected boolean focused;
        protected final YACLScreen screen;

        public LabelControllerElement(YACLScreen screen, Dimension<Integer> dim) {
            super(dim);
            this.screen = screen;
            LabelController.this.option().addListener((opt, pending) -> this.updateTooltip());
            this.updateTooltip();
            this.updateText();
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            Style style;
            this.updateText();
            int y = this.getDimension().y();
            for (FormattedCharSequence text : this.wrappedText) {
                graphics.drawString(this.textRenderer, text, this.getDimension().x() + this.getXPadding(), y + this.getYPadding(), LabelController.this.option().available() ? -1 : -6250336, true);
                Objects.requireNonNull(this.textRenderer);
                y += 9;
            }
            if (this.isFocused()) {
                graphics.fill(this.getDimension().x() - 1, this.getDimension().y() - 1, this.getDimension().xLimit() + 1, this.getDimension().y().intValue(), -1);
                graphics.fill(this.getDimension().x() - 1, this.getDimension().y() - 1, this.getDimension().x().intValue(), this.getDimension().yLimit() + 1, -1);
                graphics.fill(this.getDimension().x() - 1, this.getDimension().yLimit().intValue(), this.getDimension().xLimit() + 1, this.getDimension().yLimit() + 1, -1);
                graphics.fill(this.getDimension().xLimit().intValue(), this.getDimension().y() - 1, this.getDimension().xLimit() + 1, this.getDimension().yLimit() + 1, -1);
            }
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 100.0f);
            if (this.isMouseOver(mouseX, mouseY) && (style = this.getStyle(mouseX, mouseY)) != null && style.getHoverEvent() != null) {
                HoverEvent hoverEvent = style.getHoverEvent();
                // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable HoverEvent.ItemStackInfo itemStackContent = (HoverEvent.ItemStackInfo)hoverEvent.getValue(HoverEvent.Action.SHOW_ITEM);
                // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable HoverEvent.EntityTooltipInfo entityContent = (HoverEvent.EntityTooltipInfo)hoverEvent.getValue(HoverEvent.Action.SHOW_ENTITY);
                @Nullable Component text = (Component)hoverEvent.getValue(HoverEvent.Action.SHOW_TEXT);
                if (itemStackContent != null) {
                    ItemStack stack = itemStackContent.getItemStack();
                    this.renderItemStackTooltip(graphics, mouseX, mouseY, stack);
                } else if (entityContent != null) {
                    this.renderEntityTooltip(graphics, mouseX, mouseY, entityContent);
                } else if (text != null) {
                    this.renderTextTooltip(graphics, mouseX, mouseY, text);
                }
            }
            graphics.pose().popPose();
        }

        private void renderItemStackTooltip(GuiGraphics graphics, int mouseX, int mouseY, ItemStack itemStack) {
            graphics.renderTooltip(this.textRenderer, Screen.getTooltipFromItem((Minecraft)this.client, (ItemStack)itemStack), itemStack.getTooltipImage(), mouseX, mouseY);
        }

        private void renderEntityTooltip(GuiGraphics graphics, int mouseX, int mouseY, HoverEvent.EntityTooltipInfo entity) {
            if (this.client.options.advancedItemTooltips) {
                graphics.renderComponentTooltip(this.textRenderer, entity.getTooltipLines(), mouseX, mouseY);
            }
        }

        private void renderTextTooltip(GuiGraphics graphics, int mouseX, int mouseY, Component text) {
            MultiLineLabel multilineText = MultiLineLabel.create((Font)this.textRenderer, (FormattedText)text, (int)this.getDimension().width());
            YACLScreen.renderMultilineTooltip(graphics, this.textRenderer, multilineText, this.getDimension().centerX(), this.getDimension().y(), this.getDimension().yLimit(), this.screen.width, this.screen.height);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!this.isMouseOver(mouseX, mouseY)) {
                return false;
            }
            Style style = this.getStyle((int)mouseX, (int)mouseY);
            return this.screen.handleComponentClicked(style);
        }

        protected Style getStyle(int mouseX, int mouseY) {
            if (!this.getDimension().isPointInside(mouseX, mouseY)) {
                return null;
            }
            int x = mouseX - this.getDimension().x();
            int y = mouseY - this.getDimension().y() - this.getYPadding();
            Objects.requireNonNull(this.textRenderer);
            int line = y / 9;
            if (x < 0 || x > this.getDimension().xLimit()) {
                return null;
            }
            if (y < 0 || y > this.getDimension().yLimit()) {
                return null;
            }
            if (line < 0 || line >= this.wrappedText.size()) {
                return null;
            }
            return this.textRenderer.getSplitter().componentStyleAtWidth(this.wrappedText.get(line), x);
        }

        private int getXPadding() {
            return 4;
        }

        private int getYPadding() {
            return 3;
        }

        private void updateText() {
            this.wrappedText = this.textRenderer.split((FormattedText)LabelController.this.formatValue(), this.getDimension().width() - this.getXPadding() * 2);
            Dimension<Integer> dimension = this.getDimension();
            int n = this.wrappedText.size();
            Objects.requireNonNull(this.textRenderer);
            this.setDimension(dimension.withHeight(n * 9 + this.getYPadding() * 2));
        }

        private void updateTooltip() {
            this.wrappedTooltip = MultiLineLabel.create((Font)this.textRenderer, (FormattedText)LabelController.this.option().tooltip(), (int)(this.screen.width / 3 * 2 - 10));
        }

        @Override
        public boolean matchesSearch(String query) {
            return LabelController.this.formatValue().getString().toLowerCase().contains(query.toLowerCase());
        }

        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent focusNavigationEvent) {
            if (!LabelController.this.option().available()) {
                return null;
            }
            return !this.isFocused() ? ComponentPath.leaf((GuiEventListener)this) : null;
        }

        public boolean isFocused() {
            return this.focused;
        }

        public void setFocused(boolean focused) {
            this.focused = focused;
        }

        @Override
        public void updateNarration(NarrationElementOutput builder) {
            builder.add(NarratedElementType.TITLE, LabelController.this.formatValue());
        }

        @Override
        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
    }
}

