/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.tab;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl3.gui.tab.TabExt;
import dev.isxander.yacl3.mixin.TabNavigationBarAccessor;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.TabButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class ScrollableNavigationBar
extends TabNavigationBar {
    private static final int NAVBAR_MARGIN = 28;
    private static final Font font = Minecraft.getInstance().font;
    private int scrollOffset;
    private int maxScrollOffset;
    private final TabNavigationBarAccessor accessor = (TabNavigationBarAccessor)((Object)this);

    public ScrollableNavigationBar(int width, TabManager tabManager, Iterable<? extends Tab> tabs) {
        super(width, tabManager, (Iterable)ImmutableList.copyOf(tabs));
        for (TabButton tabButton : this.accessor.yacl$getTabButtons()) {
            Tab tab = tabButton.tab();
            if (!(tab instanceof TabExt)) continue;
            TabExt tab2 = (TabExt)tab;
            tabButton.setTooltip(tab2.getTooltip());
        }
    }

    public void arrangeElements() {
        ImmutableList<TabButton> tabButtons = this.accessor.yacl$getTabButtons();
        int noScrollWidth = this.accessor.yacl$getWidth() - 56;
        int allTabsWidth = 0;
        for (TabButton tabButton : tabButtons) {
            int buttonWidth = font.width((FormattedText)tabButton.getMessage()) + 20;
            allTabsWidth += buttonWidth;
            tabButton.setWidth(buttonWidth);
        }
        if (allTabsWidth < noScrollWidth) {
            int equalWidth = noScrollWidth / tabButtons.size();
            List<TabButton> smallTabs = tabButtons.stream().filter(btn -> btn.getWidth() < equalWidth).toList();
            List<TabButton> bigTabs = tabButtons.stream().filter(btn -> btn.getWidth() >= equalWidth).toList();
            int leftoverWidth = noScrollWidth - bigTabs.stream().mapToInt(AbstractWidget::getWidth).sum();
            int equalWidthForSmallTabs = leftoverWidth / smallTabs.size();
            for (TabButton tabButton : smallTabs) {
                tabButton.setWidth(equalWidthForSmallTabs);
            }
            allTabsWidth = noScrollWidth;
        }
        GridLayout layout = ((TabNavigationBarAccessor)((Object)this)).yacl$getLayout();
        layout.arrangeElements();
        layout.setY(0);
        this.scrollOffset = 0;
        layout.setX(Math.max((this.accessor.yacl$getWidth() - allTabsWidth) / 2, 28));
        this.maxScrollOffset = Math.max(0, allTabsWidth - noScrollWidth);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 10.0f);
        super.render(graphics, mouseX, mouseY, delta);
        graphics.pose().popPose();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontal, double vertical) {
        this.setScrollOffset(this.scrollOffset - (int)(vertical * 15.0));
        return true;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseY <= 24.0;
    }

    public void setScrollOffset(int scrollOffset) {
        GridLayout layout = ((TabNavigationBarAccessor)((Object)this)).yacl$getLayout();
        layout.setX(layout.getX() + this.scrollOffset);
        this.scrollOffset = Mth.clamp((int)scrollOffset, (int)0, (int)this.maxScrollOffset);
        layout.setX(layout.getX() - this.scrollOffset);
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public void setFocused(@Nullable GuiEventListener child) {
        super.setFocused(child);
        if (child instanceof TabButton) {
            TabButton tabButton = (TabButton)child;
            this.ensureVisible(tabButton);
        }
    }

    protected void ensureVisible(TabButton tabButton) {
        if (tabButton.getX() < 28) {
            this.setScrollOffset(this.scrollOffset - (28 - tabButton.getX()));
        } else if (tabButton.getX() + tabButton.getWidth() > this.accessor.yacl$getWidth() - 28) {
            this.setScrollOffset(this.scrollOffset + (tabButton.getX() + tabButton.getWidth() - (this.accessor.yacl$getWidth() - 28)));
        }
    }

    public ImmutableList<Tab> getTabs() {
        return this.accessor.yacl$getTabs();
    }

    public TabManager getTabManager() {
        return this.accessor.yacl$getTabManager();
    }
}

