/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.config.v2.impl.serializer;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.ConfigField;
import dev.isxander.yacl3.config.v2.api.ConfigSerializer;
import dev.isxander.yacl3.config.v2.api.FieldAccess;
import dev.isxander.yacl3.config.v2.api.SerialField;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import dev.isxander.yacl3.gui.utils.ItemRegistryHelper;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import dev.isxander.yacl3.libs.quilt.parsers.json.JsonReader;
import dev.isxander.yacl3.libs.quilt.parsers.json.JsonWriter;
import dev.isxander.yacl3.libs.quilt.parsers.json.gson.GsonReader;
import dev.isxander.yacl3.libs.quilt.parsers.json.gson.GsonWriter;
import dev.isxander.yacl3.platform.YACLPlatform;
import java.awt.Color;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.ApiStatus;

public class GsonConfigSerializer<T>
extends ConfigSerializer<T> {
    private final Gson gson;
    private final Path path;
    private final boolean json5;

    private GsonConfigSerializer(ConfigClassHandler<T> config, Path path, Gson gson, boolean json5) {
        super(config);
        this.gson = gson;
        this.path = path;
        this.json5 = json5;
    }

    @Override
    public void save() {
        YACLConstants.LOGGER.info("Serializing {} to '{}'", this.config.configClass(), (Object)this.path);
        try {
            StringWriter stringWriter = new StringWriter();
            try {
                JsonWriter jsonWriter = this.json5 ? JsonWriter.json5(stringWriter) : JsonWriter.json(stringWriter);
                GsonWriter gsonWriter = new GsonWriter(jsonWriter);
                jsonWriter.beginObject();
                for (ConfigField<?> field : this.config.fields()) {
                    JsonElement element;
                    SerialField serial = field.serial().orElse(null);
                    if (serial == null) continue;
                    if (!this.json5 && serial.comment().isPresent() && YACLPlatform.isDevelopmentEnv()) {
                        YACLConstants.LOGGER.warn("Found comment in config field '{}', but json5 is not enabled. Enable it with `.setJson5(true)` on the `GsonConfigSerializerBuilder`. Comments will not be serialized. This warning is only visible in development environments.", (Object)serial.serialName());
                    }
                    jsonWriter.comment(serial.comment().orElse(null));
                    jsonWriter.name(serial.serialName());
                    try {
                        element = this.gson.toJsonTree(field.access().get(), field.access().type());
                    }
                    catch (Exception e) {
                        YACLConstants.LOGGER.error("Failed to serialize config field '{}'. Serializing as null.", (Object)serial.serialName(), (Object)e);
                        jsonWriter.nullValue();
                        continue;
                    }
                    try {
                        this.gson.toJson(element, (com.google.gson.stream.JsonWriter)gsonWriter);
                    }
                    catch (Exception e) {
                        YACLConstants.LOGGER.error("Failed to serialize config field '{}'. Due to the error state this JSON writer cannot continue safely and the save will be abandoned.", (Object)serial.serialName(), (Object)e);
                        stringWriter.close();
                        return;
                    }
                }
                jsonWriter.endObject();
                jsonWriter.flush();
                Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                Files.writeString(this.path, (CharSequence)stringWriter.toString(), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            }
            finally {
                try {
                    stringWriter.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (IOException e) {
            YACLConstants.LOGGER.error("Failed to serialize config class '{}'.", (Object)this.config.configClass().getSimpleName(), (Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConfigSerializer.LoadResult loadSafely(Map<ConfigField<?>, FieldAccess<?>> bufferAccessMap) {
        ConfigSerializer.LoadResult loadResult;
        if (!Files.exists(this.path, new LinkOption[0])) {
            YACLConstants.LOGGER.info("Config file '{}' does not exist. Creating it with default values.", (Object)this.path);
            this.save();
            return ConfigSerializer.LoadResult.NO_CHANGE;
        }
        YACLConstants.LOGGER.info("Deserializing {} from '{}'", (Object)this.config.configClass().getSimpleName(), (Object)this.path);
        Map fieldMap = Arrays.stream(this.config.fields()).filter(field -> field.serial().isPresent()).collect(Collectors.toMap(f -> f.serial().orElseThrow().serialName(), Function.identity()));
        Set<String> missingFields = fieldMap.keySet();
        boolean dirty = false;
        try {
            JsonReader jsonReader = this.json5 ? JsonReader.json5(this.path) : JsonReader.json(this.path);
            try {
                GsonReader gsonReader = new GsonReader(jsonReader);
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    JsonElement element;
                    String name = jsonReader.nextName();
                    ConfigField field2 = (ConfigField)fieldMap.get(name);
                    missingFields.remove(name);
                    if (field2 == null) {
                        YACLConstants.LOGGER.warn("Found unknown config field '{}'.", (Object)name);
                        jsonReader.skipValue();
                        continue;
                    }
                    FieldAccess<?> bufferAccess = bufferAccessMap.get(field2);
                    SerialField serial = field2.serial().orElse(null);
                    if (serial == null) continue;
                    try {
                        element = (JsonElement)this.gson.fromJson((com.google.gson.stream.JsonReader)gsonReader, JsonElement.class);
                    }
                    catch (Exception e) {
                        YACLConstants.LOGGER.error("Failed to deserialize config field '{}'. Due to the error state this JSON reader cannot be re-used and loading will be aborted.", (Object)name, (Object)e);
                        ConfigSerializer.LoadResult loadResult2 = ConfigSerializer.LoadResult.FAILURE;
                        if (jsonReader == null) return loadResult2;
                        jsonReader.close();
                        return loadResult2;
                    }
                    if (element.isJsonNull() && !serial.nullable()) {
                        YACLConstants.LOGGER.warn("Found null value in non-nullable config field '{}'. Leaving field as default and marking as dirty.", (Object)name);
                        dirty = true;
                        continue;
                    }
                    try {
                        bufferAccess.set(this.gson.fromJson(element, bufferAccess.type()));
                    }
                    catch (Exception e) {
                        YACLConstants.LOGGER.error("Failed to deserialize config field '{}'. Leaving as default.", (Object)name, (Object)e);
                    }
                }
                jsonReader.endObject();
            }
            finally {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable) {
                        Throwable gsonReader;
                        gsonReader.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException e) {
            YACLConstants.LOGGER.error("Failed to deserialize config class.", (Throwable)e);
            return ConfigSerializer.LoadResult.FAILURE;
        }
        if (!missingFields.isEmpty()) {
            for (String missingField : missingFields) {
                if (!((ConfigField)fieldMap.get(missingField)).serial().orElseThrow().required()) continue;
                dirty = true;
                YACLConstants.LOGGER.warn("Missing required config field '{}''. Re-saving as default.", (Object)missingField);
            }
        }
        if (dirty) {
            loadResult = ConfigSerializer.LoadResult.DIRTY;
            return loadResult;
        }
        loadResult = ConfigSerializer.LoadResult.SUCCESS;
        return loadResult;
    }

    @Override
    @Deprecated
    public void load() {
        YACLConstants.LOGGER.warn("Calling ConfigSerializer#load() directly is deprecated. Please use ConfigClassHandler#load() instead.");
        this.config.load();
    }

    @ApiStatus.Internal
    public static class Builder<T>
    implements GsonConfigSerializerBuilder<T> {
        private final ConfigClassHandler<T> config;
        private Path path;
        private boolean json5;
        private UnaryOperator<GsonBuilder> gsonBuilder = builder -> builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).serializeNulls().registerTypeHierarchyAdapter(Component.class, (Object)new Component.SerializerAdapter((HolderLookup.Provider)RegistryAccess.EMPTY)).registerTypeHierarchyAdapter(Style.class, (Object)new StyleTypeAdapter()).registerTypeHierarchyAdapter(Color.class, (Object)new ColorTypeAdapter()).registerTypeHierarchyAdapter(Item.class, (Object)new ItemTypeAdapter()).setPrettyPrinting();

        public Builder(ConfigClassHandler<T> config) {
            this.config = config;
        }

        @Override
        public Builder<T> setPath(Path path) {
            this.path = path;
            return this;
        }

        @Override
        public Builder<T> overrideGsonBuilder(GsonBuilder gsonBuilder) {
            this.gsonBuilder = builder -> gsonBuilder;
            return this;
        }

        @Override
        public Builder<T> overrideGsonBuilder(Gson gson) {
            return this.overrideGsonBuilder(gson.newBuilder());
        }

        @Override
        public Builder<T> appendGsonBuilder(UnaryOperator<GsonBuilder> gsonBuilder) {
            UnaryOperator<GsonBuilder> prev = this.gsonBuilder;
            this.gsonBuilder = builder -> (GsonBuilder)gsonBuilder.apply((GsonBuilder)prev.apply((GsonBuilder)builder));
            return this;
        }

        @Override
        public Builder<T> setJson5(boolean json5) {
            this.json5 = json5;
            return this;
        }

        @Override
        public GsonConfigSerializer<T> build() {
            return new GsonConfigSerializer<T>(this.config, this.path, ((GsonBuilder)this.gsonBuilder.apply(new GsonBuilder())).create(), this.json5);
        }
    }

    public static class ItemTypeAdapter
    implements JsonSerializer<Item>,
    JsonDeserializer<Item> {
        public Item deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return ItemRegistryHelper.getItemFromName(jsonElement.getAsString());
        }

        public JsonElement serialize(Item item, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(BuiltInRegistries.ITEM.getKey((Object)item).toString());
        }
    }

    public static class ColorTypeAdapter
    implements JsonSerializer<Color>,
    JsonDeserializer<Color> {
        public Color deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return new Color(jsonElement.getAsInt(), true);
        }

        public JsonElement serialize(Color color, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)color.getRGB());
        }
    }

    public static class StyleTypeAdapter
    implements JsonSerializer<Style>,
    JsonDeserializer<Style> {
        public Style deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Style.Serializer.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result().orElse(Style.EMPTY);
        }

        public JsonElement serialize(Style src, Type typeOfSrc, JsonSerializationContext context) {
            return (JsonElement)Style.Serializer.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)src).result().orElse(JsonNull.INSTANCE);
        }
    }
}

