/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.utils;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.TriState;

public class GuiUtils {
    public static Function<ResourceLocation, RenderType> GUI_TEXTURED_FILTERED = Util.memoize(location -> RenderType.create((String)"yacl:gui_textured_filtered", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)786432, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(location, TriState.TRUE, false)).setShaderState(RenderStateShard.POSITION_TEXTURE_COLOR_SHADER).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).createCompositeState(false)));

    public static void drawSpecial(GuiGraphics graphics, Consumer<MultiBufferSource> consumer) {
        graphics.drawSpecial(consumer);
    }

    public static void blitGuiTex(GuiGraphics graphics, ResourceLocation texture, int x, int y, float u, float v, int textureWidth, int textureHeight, int width, int height) {
        GuiUtils.blitGuiTex(graphics, texture, x, y, u, v, textureWidth, textureHeight, width, height, false);
    }

    public static void blitGuiTex(GuiGraphics graphics, ResourceLocation texture, int x, int y, float u, float v, int textureWidth, int textureHeight, int width, int height, boolean linearFiltering) {
        graphics.blit(linearFiltering ? GUI_TEXTURED_FILTERED : RenderType::guiTextured, texture, x, y, u, v, textureWidth, textureHeight, width, height);
    }

    public static void blitGuiTexColor(GuiGraphics graphics, ResourceLocation texture, int x, int y, float u, float v, int textureWidth, int textureHeight, int width, int height, int color) {
        graphics.blit(RenderType::guiTextured, texture, x, y, u, v, textureWidth, textureHeight, width, height, color);
    }

    public static void blitSprite(GuiGraphics graphics, ResourceLocation sprite, int x, int y, int width, int height) {
        graphics.blitSprite(RenderType::guiTextured, sprite, x, y, width, height);
    }

    public static MutableComponent translatableFallback(String key, Component fallback) {
        if (Language.getInstance().has(key)) {
            return Component.translatable((String)key);
        }
        return fallback.copy();
    }

    public static String shortenString(String string, Font font, int maxWidth, String suffix) {
        if (((String)string).isEmpty()) {
            return string;
        }
        boolean firstIter = true;
        while (font.width((String)string) > maxWidth) {
            string = ((String)string).substring(0, Math.max(((String)string).length() - 1 - (firstIter ? 1 : suffix.length() + 1), 0)).trim();
            if (((String)(string = (String)string + suffix)).equals(suffix)) break;
            firstIter = false;
        }
        return string;
    }

    public static void setPixelARGB(NativeImage nativeImage, int x, int y, int argb) {
        nativeImage.setPixel(x, y, argb);
    }
}

